/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.planning.ActivityChange;
import cz.insophy.inplan.planning.algorithms.BubbleJoinIterator;
import cz.insophy.inplan.planning.algorithms.Direction;
import cz.insophy.inplan.planning.algorithms.Interval;
import cz.insophy.inplan.planning.algorithms.MatOfflineIterator;
import cz.insophy.inplan.planning.algorithms.OfflineMergeIterator;
import cz.insophy.inplan.planning.algorithms.RebEatingWpIterator;
import cz.insophy.inplan.planning.algorithms.RmFilteredWpIterator;
import cz.insophy.inplan.planning.algorithms.WpMatMergeIterator;
import cz.insophy.inplan.planning.mokos.DefaultRebuildDurationProvider;
import cz.insophy.inplan.planning.mokos.Positioner;
import cz.insophy.inplan.planning.mokos.PositioningResult;
import cz.insophy.inplan.planning.mokos.RebuildDurationProvider;
import cz.insophy.inplan.planning.mokos.RebuildPlanningStrategy;
import cz.insophy.inplan.planning.mokos.RebuildPositioningStart;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Bom;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.util.AbstractComparableIterator;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.SimpleComparableIterator;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class AbstractPositioner
implements Positioner {
    private RebuildPlanningStrategy rebuildPlanningStrategy = new DefaultRebuildDurationProvider();
    private RebuildPositioningStart rebuildPositioningStart = RebuildPositioningStart.BEFORE_OPERATION_BOUND;
    private static final Comparator<ActivityChange> CHANGE_COMPARATOR = new Comparator<ActivityChange>(){

        @Override
        public int compare(ActivityChange o1, ActivityChange o2) {
            int res = Comparators.compare(o1.getActivity().getStart(), o2.getActivity().getStart());
            if (res == 0) {
                res = Comparators.compare(o2.getChangeType().ordinal(), o1.getChangeType().ordinal());
            }
            return res;
        }
    };

    @Deprecated
    public void setRebuildDurationProvider(@Nonnull RebuildDurationProvider rebuildPlanningStrategy) {
        Preconditions.checkNotNull(rebuildPlanningStrategy);
        this.rebuildPlanningStrategy = rebuildPlanningStrategy;
    }

    public RebuildPlanningStrategy getRebuildPlanningStrategy() {
        return this.rebuildPlanningStrategy;
    }

    public void setRebuildPlanningStrategy(RebuildPlanningStrategy rebuildPlanningStrategy) {
        this.rebuildPlanningStrategy = Preconditions.checkNotNull(rebuildPlanningStrategy);
    }

    public RebuildPositioningStart getRebuildPositioningStart() {
        return this.rebuildPositioningStart;
    }

    public void setRebuildPositioningStart(RebuildPositioningStart rebuildPositioningStart) {
        this.rebuildPositioningStart = rebuildPositioningStart;
    }

    @Override
    public PositioningResult position(GeneralizedActionRequest gar, Action action, Plan plan, Workplace wp, long time) {
        return this.position(gar, action, plan, wp, time, Long.MIN_VALUE, true);
    }

    @Override
    public PositioningResult position(GeneralizedActionRequest gar, Action action, Plan plan, Workplace wp, long time, long timeBound) {
        return this.position(gar, action, plan, wp, time, timeBound, true);
    }

    @Override
    public PositioningResult position(GeneralizedActionRequest gar, Action action, Plan plan, Workplace wp, long time, long timeBound, boolean useTools) {
        boolean posSuccessful;
        long posStart;
        PositioningResult result = new PositioningResult();
        String rtName = action.getRebuildType();
        RebuildType rtype = wp.getRebuildType(rtName);
        Preconditions.checkState(rtype != null, "Requested positioning on a workplace %s that doesn't contain requested rebuild type %s.", (Object)wp.getName(), (Object)rtName);
        WorkplaceSchedule wps = plan.getWorkplaceSchedule(wp);
        StoreSchedule ss = plan.getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
        ArrayList<ActivityChange> actChanges = Lists.newArrayList();
        Tuple<RebuildType, Set<RebuildActivity>> sweepRes = AbstractPositioner.sweepBeforeStart(wps, time, rtype);
        RebuildType currentRType = sweepRes.getFirst();
        HashSet<RebuildActivity> removedRebs = sweepRes.getSecond() == null ? Sets.newHashSet() : sweepRes.getSecond();
        boolean rebNeeded = this.rebuildPlanningStrategy.isRebuildNeeded(currentRType, gar, action, rtype, wps, time);
        long rdur = 0L;
        if (rebNeeded) {
            rdur = this.rebuildPlanningStrategy.getRebuildDuration(currentRType, gar, action, rtype, wps, time);
            posStart = switch (this.rebuildPositioningStart) {
                default -> throw new IncompatibleClassChangeError();
                case RebuildPositioningStart.BEFORE_OPERATION_BOUND -> AbstractPositioner.findRaStart(wps, removedRebs, time, timeBound, rtype, rdur);
                case RebuildPositioningStart.AT_OPERATION_BOUND -> Math.max(time, timeBound);
            };
        } else {
            posStart = Math.max(time, timeBound);
        }
        do {
            Tuple<Deque<ActivityChange>, WorkplaceActivity> nextWaRes;
            WorkplaceActivity nextWa;
            posSuccessful = true;
            long rebEnd = Long.MIN_VALUE;
            if (rebNeeded) {
                PositioningReport report = AbstractPositioner.positionRaFrom(wps, removedRebs, ss, posStart, rtype, rdur, useTools);
                if (report.isOk.booleanValue()) {
                    actChanges.addAll(report.actChanges);
                    removedRebs.addAll(report.removedRebs);
                    long rebStart = report.timeInt.getStart();
                    rebEnd = report.timeInt.getEnd();
                    if (rebStart > time) {
                        result.setNok();
                        result.setNextPossibleTime(rebStart);
                        break;
                    }
                } else {
                    posSuccessful = false;
                    removedRebs.clear();
                    posStart = this.goToNextFreeSpace(action, wps, ss, rtype.getBom(), report.failedAt, useTools);
                }
            }
            long actEnd = Long.MIN_VALUE;
            if (posSuccessful) {
                long actPosStart = Math.max(rebNeeded ? rebEnd : posStart, time);
                PositioningReport report = this.positionActFrom(gar, action, wps, removedRebs, ss, actPosStart, useTools);
                if (report.isOk.booleanValue()) {
                    Interval actint = report.timeInt;
                    long actStart = actint.getStart();
                    actEnd = actint.getEnd();
                    actChanges.addAll(report.actChanges);
                    result.setNextPossibleTime(actStart);
                    if (!rebNeeded && actStart > time || rebNeeded && actStart > rebEnd && actStart > time && rebEnd <= time) {
                        result.setNok();
                    }
                    removedRebs.addAll(report.removedRebs);
                } else {
                    posSuccessful = false;
                    actChanges.clear();
                    removedRebs.clear();
                    posStart = this.goToNextFreeSpace(action, wps, ss, action.getBom(), report.failedAt, useTools);
                }
            }
            if (posSuccessful && !((nextWa = (nextWaRes = AbstractPositioner.goToNextWa(wps, ss, actEnd, rtype, removedRebs)).getSecond()) instanceof Bubble) && !(nextWa instanceof RebuildActivity)) {
                RebuildType nextRType = this.getRebuildTypeOf(nextWa, wp);
                Deque<ActivityChange> changes = nextWaRes.getFirst();
                if (nextRType != null) {
                    if (nextRType == rtype) {
                        if (changes != null) {
                            actChanges.addAll(changes);
                        }
                    } else {
                        long nextRdur = nextRType.getTime();
                        long postRebStart = AbstractPositioner.findRaStart(wps, removedRebs, nextWa.getStart(), timeBound, nextRType, nextRdur);
                        posSuccessful = posSuccessful && postRebStart >= actEnd;
                        PositioningReport report = null;
                        if (posSuccessful) {
                            report = AbstractPositioner.positionRaFrom(wps, removedRebs, ss, postRebStart, nextRType, nextRdur, useTools);
                            boolean bl = posSuccessful = posSuccessful && report.isOk != false;
                        }
                        if (posSuccessful) {
                            actChanges.addAll(report.actChanges);
                        }
                        if (!posSuccessful) {
                            actChanges.clear();
                            removedRebs.clear();
                            posStart = this.goToNextFreeSpace(action, wps, null, null, nextWa.getEnd(), useTools);
                        }
                    }
                }
            }
            if (posSuccessful || !(rebNeeded = this.rebuildPlanningStrategy.isRebuildNeeded(currentRType = wps.getRebuildTypeAt(posStart), gar, action, rtype, wps, posStart))) continue;
            rdur = this.rebuildPlanningStrategy.getRebuildDuration(currentRType, gar, action, rtype, wps, posStart);
        } while (!posSuccessful && posStart < Long.MAX_VALUE);
        if (posStart == Long.MAX_VALUE) {
            result.setNok();
            result.setNextPossibleTime(Long.MAX_VALUE);
        }
        if (result.isOk()) {
            for (RebuildActivity ra : removedRebs) {
                actChanges.add(new ActivityChange(ra, ActivityChange.ChangeType.REMOVED));
            }
            AbstractPositioner.fixActivityChanges(actChanges);
            result.addActivityChanges(actChanges);
        }
        return result;
    }

    @VisibleForTesting
    public static void fixActivityChanges(List<ActivityChange> changes) {
        if (changes.size() <= 1) {
            return;
        }
        HashSet<ActivityChange> unique = Sets.newHashSet(changes);
        changes.clear();
        changes.addAll(unique);
        Collections.sort(changes, CHANGE_COMPARATOR);
        ArrayList<ActivityChange> toRemove = Lists.newArrayListWithCapacity(changes.size());
        PeekingIterator<ActivityChange> it = Iterators.peekingIterator(changes.iterator());
        while (it.hasNext()) {
            ActivityChange next;
            ActivityChange change = it.next();
            if (change.getChangeType() != ActivityChange.ChangeType.REMOVED || !it.hasNext() || (next = it.peek()).getChangeType() != ActivityChange.ChangeType.ADDED || change.getActivity() != next.getActivity()) continue;
            toRemove.add(change);
            toRemove.add(next);
            it.next();
        }
        changes.removeAll(toRemove);
    }

    public static long findRaStart(WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, long time, long timeBound, RebuildType rtype, long rdur) {
        RaSpaceCollector backRaColl = RaSpaceCollector.getBackwardRaCollector(wps, removedRebs, rtype, rdur, time);
        backRaColl.collectAll();
        Interval tint = backRaColl.getPositioningInterval();
        long raStart = backRaColl.isFailed() ? backRaColl.getFailedAt() : tint.getStart();
        return Math.max(raStart, timeBound);
    }

    public static PositioningReport positionRaFrom(WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, StoreSchedule ss, long time, RebuildType rtype, long rdur, boolean useTools) {
        RaSpaceCollector forwRaColl = RaSpaceCollector.getForwardRaCollector(wps, removedRebs, ss, rtype, rdur, time, useTools);
        forwRaColl.collectAll();
        Deque<ActivityChange> achs = forwRaColl.getActivityChanges();
        Interval tint = forwRaColl.getPositioningInterval();
        boolean ok = !forwRaColl.isFailed();
        Long failedAt = !ok ? Long.valueOf(forwRaColl.getFailedAt()) : null;
        Set<RebuildActivity> eatenRebs = forwRaColl.getEatenRebs();
        return new PositioningReport(achs, tint, ok, failedAt, eatenRebs);
    }

    protected PositioningReport positionActFrom(GeneralizedActionRequest gar, Action action, WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, StoreSchedule ss, long time, boolean useTools) {
        ActSpaceCollector actionActCollector = this.getActionActCollector(gar, action, wps, removedRebs, ss, action.getBom(), time, useTools);
        actionActCollector.collectAll();
        Deque<ActivityChange> achs = actionActCollector.getActivityChanges();
        Interval tint = actionActCollector.getActsInterval();
        boolean ok = !actionActCollector.isFailed();
        Long failedAt = !ok ? Long.valueOf(actionActCollector.getFailedAt()) : null;
        Set<RebuildActivity> eatenRebs = actionActCollector.getEatenRebs();
        return new PositioningReport(achs, tint, ok, failedAt, eatenRebs);
    }

    @VisibleForTesting
    public static Tuple<Deque<ActivityChange>, WorkplaceActivity> goToNextWa(WorkplaceSchedule wps, StoreSchedule ss, long time, RebuildType rtype, Set<RebuildActivity> removedRebs) {
        NextActivitySeeker seeker = NextActivitySeeker.getForwardSeeker(wps, ss, time, rtype, removedRebs);
        seeker.collectAll();
        Deque<ActivityChange> deletedRebs = seeker.getActivityChanges();
        WorkplaceActivity nextWa = seeker.getNextWa();
        return Tuple.create(deletedRebs, nextWa);
    }

    @VisibleForTesting
    public long goToNextFreeSpace(Action act, WorkplaceSchedule wps, StoreSchedule ss, Bom bom, long time, boolean useTools) {
        BubbleSeeker seeker = act == null ? new BubbleSeeker(wps, ss, bom, time, useTools) : this.getFreeSpaceSeeker(wps, ss, bom, time, act, useTools);
        seeker.collectAll();
        return seeker.nextFreeSpaceStart();
    }

    protected abstract ActSpaceCollector getActionActCollector(GeneralizedActionRequest var1, Action var2, WorkplaceSchedule var3, Set<RebuildActivity> var4, StoreSchedule var5, Bom var6, long var7, boolean var9);

    protected abstract RebuildType getRebuildTypeOf(WorkplaceActivity var1, Workplace var2);

    protected abstract BubbleSeeker getFreeSpaceSeeker(WorkplaceSchedule var1, StoreSchedule var2, Bom var3, long var4, Action var6, boolean var7);

    protected static Tuple<RebuildType, Set<RebuildActivity>> sweepBeforeStart(WorkplaceSchedule wps, long time, RebuildType rtype) {
        RebuildType currentRt;
        HashSet<RebuildActivity> removed = null;
        WorkplaceActivity wa = wps.getActivity(time);
        boolean sweepNecessary = false;
        if (wa instanceof RebuildActivity) {
            sweepNecessary = true;
        } else if (wa instanceof OfflineActivity) {
            Iterator<WorkplaceActivity> fit = wps.forwardIteratorWithBubbles(wa.getEnd(), true);
            while (fit.hasNext()) {
                WorkplaceActivity next = fit.next();
                if (next instanceof RebuildActivity || next instanceof Bubble) {
                    sweepNecessary = true;
                    break;
                }
                if (next instanceof ActionActivity || next instanceof CumulativeWorkplaceActivity) {
                    sweepNecessary = false;
                    break;
                }
                if (next instanceof OfflineActivity) continue;
                throw new IllegalArgumentException("Unknown activity type.");
            }
        }
        if (sweepNecessary) {
            NextActivitySeeker backwardSeeker = NextActivitySeeker.getBackwardSeeker(wps, time, rtype, null);
            backwardSeeker.collectAll();
            Deque<ActivityChange> achs = backwardSeeker.getActivityChanges();
            for (ActivityChange ach : achs) {
                RebuildActivity ra = (RebuildActivity)ach.getActivity();
                if (removed == null) {
                    removed = Sets.newHashSet();
                }
                removed.add(ra);
            }
            WorkplaceActivity nextWa = backwardSeeker.getNextWa();
            currentRt = nextWa instanceof Bubble ? null : wps.getRebuildTypeAt(nextWa.getStart());
        } else {
            currentRt = wps.getRebuildTypeAt(time);
        }
        return Tuple.create(currentRt, removed);
    }

    public static class PositioningReport {
        final Set<RebuildActivity> removedRebs;
        final Deque<ActivityChange> actChanges;
        final Interval timeInt;
        final Boolean isOk;
        final Long failedAt;

        public PositioningReport(Deque<ActivityChange> actChanges, Interval timeInt, Boolean isOk, Long failedAt, Set<RebuildActivity> removedRebs) {
            this.actChanges = actChanges;
            this.timeInt = timeInt;
            this.isOk = isOk;
            this.failedAt = failedAt;
            this.removedRebs = removedRebs;
        }

        public Deque<ActivityChange> getActChanges() {
            return this.actChanges;
        }

        public Interval getTimeInt() {
            return this.timeInt;
        }

        public Boolean getIsOk() {
            return this.isOk;
        }

        public Long getFailedAt() {
            return this.failedAt;
        }
    }

    protected static class RaSpaceCollector
    extends RaEatingCollector {
        private final RebuildType rtype;
        private final long rdur;
        private long collectedTime = 0L;
        private long posStart;
        private long posEnd;

        private RaSpaceCollector(WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, StoreSchedule ss, Bom bom, RebuildType rtype, long rdur, long time, Direction dir, boolean useTools) {
            super(wps, removedRebs, ss, bom, time, dir, rtype.getName(), useTools);
            this.rtype = rtype;
            this.rdur = rdur;
            this.posStart = Long.MAX_VALUE;
            this.posEnd = Long.MIN_VALUE;
        }

        public static RaSpaceCollector getForwardRaCollector(WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, StoreSchedule ss, RebuildType rtype, long rdur, long time, boolean useTools) {
            return new RaSpaceCollector(wps, removedRebs, ss, rtype.getBom(), rtype, rdur, time, Direction.FORWARD, useTools);
        }

        public static RaSpaceCollector getBackwardRaCollector(WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, RebuildType rtype, long rdur, long time) {
            return new RaSpaceCollector(wps, removedRebs, null, null, rtype, rdur, time, Direction.BACKWARD, false);
        }

        @Override
        public boolean isCollectingComplete() {
            return this.collectedTime >= this.rdur;
        }

        public Interval getPositioningInterval() {
            Preconditions.checkState(this.isFinished());
            if (this.posStart == Long.MAX_VALUE || this.posEnd == Long.MIN_VALUE) {
                return null;
            }
            return new Interval(this.posStart, this.posEnd);
        }

        @Override
        protected List<ActivityChange> process(WorkplaceActivity wa) {
            ArrayList<ActivityChange> aChs;
            if (wa instanceof Bubble) {
                long rebEnd;
                long rebStart;
                Bubble bbl = (Bubble)wa;
                long leftToCollect = this.rdur - this.collectedTime;
                long bubbDuration = bbl.getDuration();
                if (this.getDirection() == Direction.FORWARD) {
                    rebStart = bbl.getStart();
                    rebEnd = bubbDuration > leftToCollect ? rebStart + leftToCollect : bbl.getEnd();
                } else {
                    rebEnd = bbl.getEnd();
                    rebStart = bubbDuration > leftToCollect ? rebEnd - leftToCollect : bbl.getStart();
                }
                this.collectedTime += Math.min(bubbDuration, leftToCollect);
                aChs = Lists.newArrayList(new ActivityChange(new RebuildActivity(rebStart, rebEnd, bbl.getWorkplace(), this.rtype), ActivityChange.ChangeType.ADDED));
                if (rebStart < this.posStart) {
                    this.posStart = rebStart;
                }
                if (rebEnd > this.posEnd) {
                    this.posEnd = rebEnd;
                }
            } else if (wa instanceof OfflineActivity && this.rtype.getDivisibility() == RebuildType.RebuildDivisibility.DIVISIBLE && !((OfflineActivity)wa).isDividing()) {
                aChs = null;
            } else {
                if (this.getDirection() == Direction.FORWARD) {
                    this.failAt(wa.getStart());
                } else {
                    this.failAt(wa.getEnd());
                }
                aChs = null;
            }
            return aChs;
        }
    }

    protected static abstract class ActSpaceCollector
    extends RaEatingCollector {
        private final GeneralizedActionRequest gar;
        private final Action action;
        private long actsStart;
        private long actsEnd;

        ActSpaceCollector(GeneralizedActionRequest gar, Action action, WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, StoreSchedule ss, Bom bom, long time, Direction dir, boolean useTools) {
            super(wps, removedRebs, ss, bom, time, dir, action.getRebuildType(), useTools);
            this.gar = gar;
            this.action = action;
            this.actsStart = Long.MAX_VALUE;
            this.actsEnd = Long.MIN_VALUE;
        }

        public GeneralizedActionRequest getGar() {
            return this.gar;
        }

        public Action getAction() {
            return this.action;
        }

        public Interval getActsInterval() {
            Preconditions.checkState(this.isFinished());
            if (this.actsStart == Long.MAX_VALUE || this.actsEnd == Long.MIN_VALUE) {
                return null;
            }
            return new Interval(this.actsStart, this.actsEnd);
        }

        protected void updateActsInterval(long start, long end) {
            if (start < this.actsStart) {
                this.actsStart = start;
            }
            if (end > this.actsEnd) {
                this.actsEnd = end;
            }
        }
    }

    protected static class NextActivitySeeker
    extends AbstractWaChangeCollector {
        private WorkplaceActivity nextWa;
        private final RebuildType rtype;

        private NextActivitySeeker(WorkplaceSchedule wps, StoreSchedule ss, Bom bom, long time, RebuildType rtype, Direction dir, Set<RebuildActivity> removedRebs) {
            super(wps, removedRebs, ss, bom, time, dir, false);
            this.rtype = Preconditions.checkNotNull(rtype);
        }

        static NextActivitySeeker getForwardSeeker(WorkplaceSchedule wps, StoreSchedule ss, long time, RebuildType rtype, Set<RebuildActivity> removedRebs) {
            return new NextActivitySeeker(wps, ss, rtype.getBom(), time, rtype, Direction.FORWARD, removedRebs);
        }

        static NextActivitySeeker getBackwardSeeker(WorkplaceSchedule wps, long time, RebuildType rtype, Set<RebuildActivity> removedRebs) {
            return new NextActivitySeeker(wps, null, null, time, rtype, Direction.BACKWARD, removedRebs);
        }

        @Override
        public boolean isCollectingComplete() {
            return this.getNextWa() != null;
        }

        @Override
        protected List<ActivityChange> process(WorkplaceActivity wa) {
            ArrayList<ActivityChange> aChs;
            if (this.getDirection() == Direction.BACKWARD && wa.getEnd() > this.getTime()) {
                return null;
            }
            if (wa instanceof CumulativeWorkplaceActivity || wa instanceof ActionActivity) {
                this.nextWa = wa;
                aChs = null;
            } else if (wa instanceof RebuildActivity) {
                RebuildActivity ra = (RebuildActivity)wa;
                RebuildType toType = ra.getToType();
                if (!this.rtype.equals(toType)) {
                    this.nextWa = ra;
                    aChs = null;
                } else {
                    aChs = Lists.newArrayList(new ActivityChange(ra, ActivityChange.ChangeType.REMOVED));
                }
            } else if (wa instanceof Bubble) {
                Bubble bub = (Bubble)wa;
                if (bub.isFirst() || bub.isLast()) {
                    this.nextWa = wa;
                }
                aChs = null;
            } else if (wa instanceof OfflineActivity) {
                aChs = null;
            } else {
                throw new IllegalArgumentException("Unknown activity type");
            }
            return aChs;
        }

        public WorkplaceActivity getNextWa() {
            return this.nextWa;
        }
    }

    protected static class BubbleSeeker
    extends AbstractWaChangeCollector {
        private WorkplaceActivity nextSpace;

        public BubbleSeeker(WorkplaceSchedule wps, StoreSchedule ss, Bom bom, long time, boolean useTools) {
            super(wps, ss, bom, time, Direction.FORWARD, useTools);
        }

        protected void setNextSpace(WorkplaceActivity nextSpace) {
            Preconditions.checkState(this.nextSpace == null);
            this.nextSpace = nextSpace;
        }

        public long nextFreeSpaceStart() {
            if (this.isFailed()) {
                return Long.MAX_VALUE;
            }
            return this.nextSpace.getStart();
        }

        @Override
        public boolean isCollectingComplete() {
            return this.nextSpace != null;
        }

        @Override
        protected List<ActivityChange> process(WorkplaceActivity wa) {
            if (wa instanceof Bubble) {
                this.nextSpace = wa;
            } else if (wa instanceof OfflineActivity && wa.getEnd() == Long.MAX_VALUE) {
                this.failAt(wa.getStart());
            }
            return null;
        }
    }

    protected static abstract class RaEatingCollector
    extends AbstractWaChangeCollector {
        private RebEatingWpIterator rebEatingIt;
        private final RebuildType rebuildType;

        RaEatingCollector(WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, StoreSchedule ss, Bom bom, long time, Direction dir, String rtName, boolean useTools) {
            super(wps, removedRebs, ss, bom, time, dir, useTools);
            RebuildType rebuildType = wps.getWorkplace().getRebuildType(rtName);
            Preconditions.checkNotNull(rebuildType);
            this.rebuildType = rebuildType;
        }

        @Override
        protected Iterator<WorkplaceActivity> createPlanningIterator(WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, StoreSchedule ss, Bom bom, long time, Direction dir, boolean useTools) {
            Iterator<WorkplaceActivity> it = RaEatingCollector.createWpMatIterator(wps, ss, bom, time, dir, useTools);
            if (removedRebs != null) {
                it = new RmFilteredWpIterator(removedRebs, it, time, dir);
            }
            this.rebEatingIt = new RebEatingWpIterator(this.rebuildType, it, time, dir);
            it = new BubbleJoinIterator(this.rebEatingIt);
            return it;
        }

        public Set<RebuildActivity> getEatenRebs() {
            return this.rebEatingIt.getEatenRebs();
        }
    }

    protected static abstract class AbstractWaChangeCollector {
        private final WorkplaceSchedule wps;
        private final StoreSchedule ss;
        private final Bom bom;
        private final long time;
        private final Direction dir;
        private final Set<RebuildActivity> removedRebs;
        private final boolean useTools;
        private final Deque<ActivityChange> changes;
        private boolean failed;
        private long failedAt;

        AbstractWaChangeCollector(WorkplaceSchedule wps, StoreSchedule ss, Bom bom, long time, Direction dir, boolean useTools) {
            this(wps, null, ss, bom, time, dir, useTools);
        }

        AbstractWaChangeCollector(WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, StoreSchedule ss, Bom bom, long time, Direction dir, boolean useTools) {
            this.wps = wps;
            this.ss = ss;
            this.bom = bom;
            this.time = time;
            this.dir = dir;
            this.removedRebs = removedRebs;
            this.useTools = useTools;
            this.failed = false;
            this.changes = new ArrayDeque<ActivityChange>();
        }

        protected Direction getDirection() {
            return this.dir;
        }

        protected long getTime() {
            return this.time;
        }

        protected abstract List<ActivityChange> process(WorkplaceActivity var1);

        protected Iterator<WorkplaceActivity> createPlanningIterator(WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, StoreSchedule ss, Bom bom, long time, Direction dir, boolean useTools) {
            BubbleJoinIterator it = AbstractWaChangeCollector.createWpMatIterator(wps, ss, bom, time, dir, useTools);
            if (removedRebs != null) {
                it = new BubbleJoinIterator(new RmFilteredWpIterator(removedRebs, it, time, dir));
            }
            return it;
        }

        protected static Iterator<WorkplaceActivity> createWpMatIterator(WorkplaceSchedule wps, StoreSchedule ss, Bom bom, long time, Direction dir, boolean useTools) {
            WpMatMergeIterator res;
            Preconditions.checkArgument(bom == null || ss != null);
            Preconditions.checkArgument(dir == Direction.FORWARD || dir == Direction.BACKWARD && ss == null && bom == null);
            WpMatMergeIterator wpIter = switch (dir) {
                case Direction.BACKWARD -> wps.backwardIteratorWithBubblesCut(time);
                default -> wps.forwardIteratorWithBubblesCut(time);
            };
            if (useTools) {
                Set<AbstractComparableIterator<OfflineActivity>> matIters = Sets.newIdentityHashSet();
                if (ss != null && bom != null) {
                    for (MaterialQuantity mq : bom) {
                        Material m3 = mq.getMaterial();
                        if (m3.isConsumed()) continue;
                        matIters.add(new MatOfflineIterator(ss, m3, time, mq.getQty()));
                    }
                }
                res = matIters.isEmpty() ? wpIter : new WpMatMergeIterator(new SimpleComparableIterator<WorkplaceActivity>(wpIter), new OfflineMergeIterator(matIters));
            } else {
                res = wpIter;
            }
            return res;
        }

        public void collectAll() {
            Iterator<WorkplaceActivity> it = this.createPlanningIterator(this.wps, this.removedRebs, this.ss, this.bom, this.time, this.dir, this.useTools);
            while (it.hasNext() && !this.isFinished()) {
                WorkplaceActivity wa = it.next();
                if ((this.dir != Direction.FORWARD || wa.getEnd() <= this.time) && (this.dir != Direction.BACKWARD || wa.getStart() >= this.time)) continue;
                this.collect(wa);
            }
        }

        protected void collect(WorkplaceActivity wa) {
            Preconditions.checkState(!this.isFinished());
            List<ActivityChange> aChs = this.process(wa);
            if (aChs != null) {
                this.changes.addAll(aChs);
            }
        }

        public Deque<ActivityChange> getActivityChanges() {
            return this.changes;
        }

        public boolean isFailed() {
            return this.failed;
        }

        protected void failAt(long failedAt) {
            this.failed = true;
            this.failedAt = failedAt;
        }

        public long getFailedAt() {
            Preconditions.checkState(this.failed);
            return this.failedAt;
        }

        public abstract boolean isCollectingComplete();

        public boolean isFinished() {
            return this.failed || this.isCollectingComplete();
        }
    }
}

